// background.js
let walletStatus = {
  detected: false,
  connected: false,
  accounts: []
};

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'WALLET_DETECTED') {
    walletStatus.detected = request.hasWallet;
  }
  
  if (request.type === 'ACCOUNTS_CHANGED') {
    walletStatus.accounts = request.accounts;
    walletStatus.connected = request.accounts.length > 0;
  }
});