// content.js
// 检测是否有钱包并向扩展发送消息
function detectWallet() {
  const hasWallet = typeof window.ethereum !== 'undefined';
  chrome.runtime.sendMessage({
    type: 'WALLET_DETECTED',
    hasWallet: hasWallet
  });
}

// 页面加载时检测钱包
detectWallet();

// 监听来自popup的请求
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'CHECK_WALLET') {
    const hasWallet = typeof window.ethereum !== 'undefined';
    sendResponse({ hasWallet: hasWallet });
    return true;
  }
  
  if (request.type === 'CONNECT_WALLET') {
    if (typeof window.ethereum !== 'undefined') {
      window.ethereum.request({ method: 'eth_requestAccounts' })
        .then(accounts => {
          sendResponse({ success: true, accounts: accounts });
        })
        .catch(error => {
          sendResponse({ success: false, error: error.message });
        });
      return true; // 保持通道开放以进行异步响应
    } else {
      sendResponse({ success: false, error: 'No wallet detected' });
    }
  }
  
  if (request.type === 'GET_ACCOUNTS') {
    if (typeof window.ethereum !== 'undefined') {
      window.ethereum.request({ method: 'eth_accounts' })
        .then(accounts => {
          sendResponse({ success: true, accounts: accounts });
        })
        .catch(error => {
          sendResponse({ success: false, error: error.message });
        });
      return true;
    } else {
      sendResponse({ success: false, error: 'No wallet detected' });
    }
  }
});

// 监听账户变化
if (typeof window.ethereum !== 'undefined') {
  window.ethereum.on('accountsChanged', (accounts) => {
    chrome.runtime.sendMessage({
      type: 'ACCOUNTS_CHANGED',
      accounts: accounts
    });
  });
}